﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:cif="cif">
    <xsl:param name="xslShowHelp" select="cif:xslShowHelp"/>
    <xsl:param name="xslResourceDirectory" select="cif:xslResourceDirectory"/>

  <!--Horizontal Alignment Legal Description Report-->
  <xsl:template match="/">
    <xsl:variable name="gridOut" select="cif:SetGridOut(number(InRoads/@outputGridScaleFactor))" />
    <html lang="en">
      <head>
        <link rel="stylesheet" type="text/css" href="{$xslResourceDirectory}/engtheme.css"/>
        <!--link rel="stylesheet" type="text/css" href="{$xslResourceDirectory}/engtheme.css"/-->
        <!-- Title displayed in browser Title Bar -->
        <!--title>CDOT A-line Description</title-->
      </head>
      <body>
        <xsl:for-each select="InRoads">
          <p lang="en">
            <!-- Report Title -->
            <!--h2>Horizontal Alignment Legal Description</h2-->
            <xsl:for-each select="GeometryProject">
              <xsl:variable name="ProjNum">
  <xsl:value-of select="@name" />
              </xsl:variable>
              <xsl:variable name="PC">
  <xsl:value-of select="@description" />
              </xsl:variable>
              <xsl:for-each select="HorizontalAlignment">
  <xsl:variable name="Date">
    <xsl:value-of select="@lastRevisedDate" />
  </xsl:variable>
  <xsl:variable name="ParNum">
    <xsl:value-of select="@name" />
  </xsl:variable>
  <h3>
    <center>
      <b>EXHIBIT "B"</b>
      <br />
      <br />
    
PROJECT NUMBER: <xsl:value-of select="$ProjNum" />
<br />
    
PARCEL NUMBER: <xsl:value-of select="$ParNum" />
<br />
    
PROJECT CODE: <xsl:value-of select="$PC" />
<br />
    
DATE: <xsl:value-of select="cif:date()" />
<br />
<th class="underline" lang="en">ACCESS DESCRIPTION</th></center>
  </h3>
  <br />
  <left>EACH AND EVERY RIGHT OR RIGHTS OF ACCESS OF THE GRANTOR to and from any part of the right-of-way of Colorado State Highway No. XXX, a freeway established according to the laws of the State of Colorado, and from and to any part of the real property of the Grantor in the .... of Section XX, Township X X, Range XX X, of the X Principal Meridian, in X County, Colorado abutting upon said Highway, along and across the access line or lines described as follows:<br /><br /></left>
  <center>
    <pre>
      <table align="center" width="60%">
        <tr>
          <td width="30%" align="center">
   <xsl:value-of select="$ProjNum" />
          </td>
          <td width="40%" align="center">
   <xsl:value-of select="$ParNum" />
          </td>
          <td width="30%" align="center">XXXerly Line</td>
        </tr>
        <tr>
          <td align="center">(Proj. No.)</td>
          <td align="center">(Parcel No.)</td>
          <td align="center">Location of Line</td>
        </tr>
      </table>
    </pre>
  </center>
  <left>
    <br /> Beginning at a point, whence XXXX;<br /><br /><xsl:apply-templates />
 Basis of Bearings: All bearings are based on a line between .....
 Excepting from this grant, the right of the Grantor to have the following points of access at the locations set forth hereinafter, to be limited in use by the Grantor to the width and location hereinafter designated according to centerline stationing of the Grantee's project number.<br /><br /></left>
  <center>
 WIDTH  CENTER OF ACCESS OPENING OPPOSITE<br /><br />
 40' Left or Right Station XXX+XX<br /><br />
 OR<br /><br />
      	
      NO ACCESS POINT<br /><br /></center>
              </xsl:for-each>
            </xsl:for-each>
          </p>
        </xsl:for-each>
      </body>
    </html>
  </xsl:template>
  <!-- Horizontal Line -->
  <xsl:template match="HorizontalLine">
    <xsl:choose>
      <xsl:when test="position() = 1">
        <blockquote>
          <xsl:number count="HorizontalLine | HorizontalCircle | HorizontalSpiral" />.  Thence 
<xsl:value-of select="cif:directionFormat(number(@direction))" />, a distance of <xsl:value-of select="cif:distanceFormat(number(@length))" /> feet;
	</blockquote>
        <br />
      </xsl:when>
      <xsl:when test="position() = last()">
        <blockquote>
          <xsl:number count="HorizontalLine | HorizontalCircle | HorizontalSpiral" />. Thence 
<xsl:value-of select="cif:directionFormat(number(@direction))" />,
  a distance of <xsl:value-of select="cif:distanceFormat(number(@length))" /> feet.

	</blockquote>
        <br />
      </xsl:when>
      <xsl:otherwise>
        <blockquote>
          <xsl:number count="HorizontalLine | HorizontalCircle | HorizontalSpiral" />.  Thence 
<xsl:value-of select="cif:directionFormat(number(@direction))" />,
  a distance of <xsl:value-of select="cif:distanceFormat(number(@length))" /> feet;
  </blockquote>
        <br />
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <!-- Horizontal Circle -->
  <xsl:template match="HorizontalCircle">
    <xsl:choose>
      <xsl:when test="position() = 1">
        <blockquote>
          <xsl:number count="HorizontalLine | HorizontalCircle | HorizontalSpiral" />.  Thence on the arc of a curve to the <xsl:if test="@rotationDirection='ccw'">  left,  </xsl:if><xsl:if test="@rotationDirection='cw'">  right,  </xsl:if>
  a radius of
  <xsl:value-of select="cif:distanceFormat(number(@radius))" />
  feet, a central angle of
  <xsl:value-of select="cif:angularFormat(number(@delta))" />,
  a distance of
  <xsl:value-of select="cif:distanceFormat(number(@length))" /> 
  feet, (a chord bearing <xsl:value-of select="cif:directionFormat(number(@chordDirection))" />,
  a distance of
  <xsl:value-of select="cif:distanceFormat(number(@chord))" />
  feet);

	</blockquote>
        <br />
        <br />
      </xsl:when>
      <xsl:when test="position() = last()">
        <blockquote>
          <xsl:number count="HorizontalLine | HorizontalCircle | HorizontalSpiral" />.  Thence on the arc of a curve to the <xsl:if test="@rotationDirection='ccw'">  left,  </xsl:if><xsl:if test="@rotationDirection='cw'">  right,  </xsl:if>
  a radius of
  <xsl:value-of select="cif:distanceFormat(number(@radius))" />
  feet, a central angle of
  <xsl:value-of select="cif:angularFormat(number(@delta))" />,  a distance of <xsl:value-of select="cif:distanceFormat(number(@length))" />
  feet, (a chord bearing
  <xsl:value-of select="cif:directionFormat(number(@chordDirection))" />,
  a distance of
  <xsl:value-of select="cif:distanceFormat(number(@chord))" />
  feet).<br />
	</blockquote>
        <br />
      </xsl:when>
      <xsl:otherwise>
        <blockquote>
          <xsl:number count="HorizontalLine | HorizontalCircle | HorizontalSpiral" />.  Thence on the arc of a curve to the <xsl:if test="@rotationDirection='ccw'">  left,  </xsl:if><xsl:if test="@rotationDirection='cw'">  right,  </xsl:if>
  a radius of
  <xsl:value-of select="cif:distanceFormat(number(@radius))" />
  feet, a central angle of
  <xsl:value-of select="cif:angularFormat(number(@delta))" />,  a distance of <xsl:value-of select="cif:distanceFormat(number(@length))" />
  feet, (a chord bearing <xsl:value-of select="cif:directionFormat(number(@chordDirection))" />,
  a distance of
  <xsl:value-of select="cif:distanceFormat(number(@chord))" />
  feet);
	</blockquote>
        <br />
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <!-- Horizontal Spiral -->
  <xsl:template match="HorizontalSpiral">
    <xsl:choose>
      <xsl:when test="position() = 1">
        <blockquote>
          <xsl:number count="HorizontalLine | HorizontalCircle | HorizontalSpiral" />.  Thence on the arc of a  <xsl:value-of select="cif:distanceFormat(number(@length))" />
  foot spiral curve to the
  <xsl:if test="@rotationDirection='ccw'"> left,  </xsl:if><xsl:if test="@rotationDirection='cw'"> right, </xsl:if>
  a beginning radius of <xsl:value-of select="cif:distanceFormat(number(@startRadius))" />
  feet, an ending radius of
  <xsl:value-of select="cif:distanceFormat(number(@endRadius))" />
  feet, a Theta angle of
  <xsl:value-of select="cif:angularFormat(number(@thetaAngle))" />, (a chord bearing
  <xsl:value-of select="cif:directionFormat(number(@chordDirection))" />,
  a distance of
  <xsl:value-of select="cif:distanceFormat(number(@longChord))" /> feet);<br /><br />
	</blockquote>
      </xsl:when>
      <xsl:when test="position() = last()">
        <blockquote>
          <xsl:number count="HorizontalLine | HorizontalCircle | HorizontalSpiral" />.  Thence on the arc of a  <xsl:value-of select="cif:distanceFormat(number(@length))" />
  foot spiral curve to the
  <xsl:if test="@rotationDirection='ccw'"> left,  </xsl:if><xsl:if test="@rotationDirection='cw'"> right, </xsl:if>
  a beginning radius of <xsl:value-of select="cif:distanceFormat(number(@startRadius))" />
  feet, an ending radius of
  <xsl:value-of select="cif:distanceFormat(number(@endRadius))" />
  feet, a Theta angle of
  <xsl:value-of select="cif:angularFormat(number(@thetaAngle))" />, (a chord bearing
  <xsl:value-of select="cif:directionFormat(number(@chordDirection))" />,
  a distance of
  <xsl:value-of select="cif:distanceFormat(number(@longChord))" />
 feet).
	</blockquote>
        <br />
      </xsl:when>
      <xsl:otherwise>
        <blockquote>
          <xsl:number count="HorizontalLine | HorizontalCircle | HorizontalSpiral" />.  Thence on the arc of a  <xsl:value-of select="cif:distanceFormat(number(@length))" />
  foot spiral curve to the
  <xsl:if test="@rotationDirection='ccw'">
 left,  </xsl:if><xsl:if test="@rotationDirection='cw'">
 right, </xsl:if>
  a beginning radius of <xsl:value-of select="cif:distanceFormat(number(@startRadius))" />
  feet, an ending radius of
  <xsl:value-of select="cif:distanceFormat(number(@endRadius))" />
  feet, a Theta angle of
  <xsl:value-of select="cif:angularFormat(number(@thetaAngle))" />, (a chord bearing
  <xsl:value-of select="cif:directionFormat(number(@chordDirection))" />,
  a distance of
  <xsl:value-of select="cif:distanceFormat(number(@longChord))" /> feet); 
  	</blockquote>
        <br />
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
</xsl:stylesheet>